<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryProduct extends Model 
{

    protected $table = 'inventories_products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('inventory_id', 'product_id', 'quantity');

    public function product()
    {
        return $this->belongsTo('Models\Product', 'product_id');
    }

    public function inventory()
    {
        return $this->belongsTo('Models\Inventory', 'inventory_id');
    }

}