<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TimeSchedul extends Model 
{

    protected $table = 'time_schedules';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('doctor_id', 'day', 'time_from', 'time_to', 'appointments_duration', 'notes');

    public function doctor()
    {
        return $this->belongsTo('Models\Doctor', 'doctor_id');
    }

}