<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('patient_id');
			$table->integer('doctor_id');
			$table->double('discount')->default('0');
			$table->enum('discount_type', array('percent', 'fixed'));
			$table->double('total')->default('0');
			$table->double('total_after_discount')->default('0');
			$table->text('notes')->nullable();
			$table->double('paid_amount')->default('0');
			$table->integer('reference_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}