<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientCasesTable extends Migration {

	public function up()
	{
		Schema::create('patient_cases', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->integer('doctor_id');
			$table->integer('patient_id');
			$table->string('title')->nullable();
			$table->longText('details');
		});
	}

	public function down()
	{
		Schema::drop('patient_cases');
	}
}