<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimeSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('time_schedules', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->integer('doctor_id');
			$table->date('day')->nullable();
			$table->time('time_from')->nullable();
			$table->time('time_to')->nullable();
			$table->integer('appointments_duration')->default('0');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('time_schedules');
	}
}