<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonorsTable extends Migration {

	public function up()
	{
		Schema::create('donors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->nullable();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->date('last_donation_date')->nullable();
			$table->date('date')->nullable();
			$table->string('age')->nullable();
			$table->enum('gender', array('male', 'female', 'other.'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('donors');
	}
}