<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('category_id')->nullable();
			$table->string('name')->nullable();
			$table->float('sale_price')->default('0');
			$table->float('purchase_price')->nullable();
			$table->string('generic_name')->nullable();
			$table->date('expire_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}