<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Schedule extends Model 
{

    protected $table = 'schedule';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->belongsTo('TypeActivity');
    }

    public function place()
    {
        return $this->belongsTo('Places', 'id_place');
    }

    public function location()
    {
        return $this->belongsTo('Locations');
    }

}