<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('flats', function(Blueprint $table) {
			$table->foreign('apartment_id')->references('id')->on('apartments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('people', function(Blueprint $table) {
			$table->foreign('flat_id')->references('id')->on('flats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('flats', function(Blueprint $table) {
			$table->dropForeign('flats_apartment_id_foreign');
		});
		Schema::table('people', function(Blueprint $table) {
			$table->dropForeign('people_flat_id_foreign');
		});
	}
}