<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Apartment extends Eloquent {

	protected $table = 'apartments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'door_number', 'address', 'block');

	public function flats()
	{
		return $this->hasMany('App\Models\Flat', 'id', 'apartment_id');
	}

}