<?php

namespace App\Modules\Chat\Entities;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;
	protected $fillable = array('name', 'status');

	public function managers()
	{
		return $this->morphedByMany('App\Models\Manager', 'groupable');
	}

	public function admins()
	{
		return $this->morphedByMany('App\Models\Admin', 'groupable');
	}

	public function messages()
	{
		return $this->hasMany('App\Modules\Chat\Entities\Message');
	}

}