<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('names', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('values', function(Blueprint $table) {
			$table->foreign('relation_id')->references('id')->on('relations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('values', function(Blueprint $table) {
			$table->foreign('audience_id')->references('id')->on('audiences')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('audiences', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->foreign('relation_id')->references('id')->on('relations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->foreign('name_id')->references('id')->on('names')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->foreign('value_id')->references('id')->on('values')
						->onDelete('cascade')
						->onUpdate('set null');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->foreign('audience_id')->references('id')->on('audiences')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('names', function(Blueprint $table) {
			$table->dropForeign('names_group_id_foreign');
		});
		Schema::table('values', function(Blueprint $table) {
			$table->dropForeign('values_relation_id_foreign');
		});
		Schema::table('values', function(Blueprint $table) {
			$table->dropForeign('values_audience_id_foreign');
		});
		Schema::table('audiences', function(Blueprint $table) {
			$table->dropForeign('audiences_job_id_foreign');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->dropForeign('Attitudes_relation_id_foreign');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->dropForeign('Attitudes_name_id_foreign');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->dropForeign('Attitudes_group_id_foreign');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->dropForeign('Attitudes_value_id_foreign');
		});
		Schema::table('Attitudes', function(Blueprint $table) {
			$table->dropForeign('Attitudes_audience_id_foreign');
		});
	}
}