<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUCollectionsUrlsTable extends Migration {

	public function up()
	{
		Schema::create('u_collections_urls', function(Blueprint $table) {
			$table->integer('cuid')->unsigned();
			$table->integer('cid')->nullable();
			$table->string('type', 255);
			$table->string('title', 1024);
			$table->string('desc', 255)->default('''');
			$table->text('url');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('u_collections_urls');
	}
}