<?php

namespace Src\Domain\Shared;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tag extends Eloquent {

	protected $table = 'tags';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type', 'color');
	protected $visible = array('id');
	protected $hidden = array('timestamps');

	public function tagable()
	{
		return $this->morphTo();
	}

}