<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuscriptionsTypesComptesTable extends Migration {

	public function up()
	{
		Schema::create('suscriptions_types_comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('compte')->unsigned()->nullable();
			$table->integer('type_compte')->unsigned();
			$table->enum('groupe1', array('CLASSIQUE', 'JEUNE'));
			$table->enum('groupe2', array('AVANTAGE', 'PREMIER'))->nullable();
			$table->boolean('diaspora')->nullable();
			$table->enum('epargne_projet', array('Argent', 'or'))->nullable();
			$table->string('status', 10)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('suscriptions_types_comptes');
	}
}