<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Patrimony extends Model 
{

    protected $table = 'patrimonies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'number', 'available', 'softDeletes');
    protected $visible = array('product_id', 'number', 'available', 'softDeletes');

    public function product()
    {
        return $this->belongsTo('Product');
    }

}