<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBeneficiaryAddressesTable extends Migration {

	public function up()
	{
		Schema::create('beneficiary_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('beneficiary_id')->unsigned();
			$table->string('zipcode', 10);
			$table->string('street', 45);
			$table->string('number', 15);
			$table->string('district');
			$table->string('city', 45);
			$table->char('state', 2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('beneficiary_addresses');
	}
}