<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryAddressesTable extends Migration {

	public function up()
	{
		Schema::create('delivery_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('zipcode')->nullable();
			$table->string('street', 45)->nullable();
			$table->string('number', 15)->nullable();
			$table->string('district', 100)->nullable();
			$table->string('city', 45)->nullable();
			$table->string('state', 2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('delivery_addresses');
	}
}