<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('name', 50);
			$table->string('description', 100)->nullable();
			$table->decimal('price', 8,2);
			$table->integer('stock')->unsigned()->nullable();
			$table->float('weight');
			$table->float('length');
			$table->float('width');
			$table->float('height');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}