<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->string('zipcode', 10)->nullable();
			$table->string('street', 45)->nullable();
			$table->string('number', 15)->nullable();
			$table->string('district', 100)->nullable();
			$table->string('city', 45)->nullable();
			$table->string('state', 2)->nullable();
			$table->text('note')->nullable()->default('200');
			$table->string('payment_method')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}