<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentSlipsTable extends Migration {

	public function up()
	{
		Schema::create('payment_slips', function(Blueprint $table) {
			$table->string('title', 10)->default('accept');
			$table->increments('id');
			$table->boolean('accept')->nullable()->default(false);
			$table->string('document', 15);
			$table->string('number', 50)->nullable();
			$table->integer('sequential')->nullable();
			$table->date('emission');
			$table->date('due_date');
			$table->decimal('value', 8,2);
			$table->timestamps();
			$table->decimal('interest', 8,2)->nullable()->default('0');
			$table->decimal('mulct', 8,2)->nullable();
			$table->string('instruction')->nullable();
			$table->integer('bank_account_id')->unsigned();
			$table->integer('customer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('payment_slips');
	}
}