<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_password_resets', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('freight_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('freight_categories', function(Blueprint $table) {
			$table->foreign('freight_id')->references('id')->on('freights')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variants', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patrimonies', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('variant_values', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('delivery_addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('benefeciary_id')->references('id')->on('beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beneficiary_addresses', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_slips', function(Blueprint $table) {
			$table->foreign('bank_account_id')->references('id')->on('bank_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_slips', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment_slip', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customer_addresses', function(Blueprint $table) {
			$table->dropForeign('customer_addresses_customer_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('customer_password_resets', function(Blueprint $table) {
			$table->dropForeign('customer_password_resets_customer_id_foreign');
		});
		Schema::table('freight_categories', function(Blueprint $table) {
			$table->dropForeign('freight_categories_category_id_foreign');
		});
		Schema::table('freight_categories', function(Blueprint $table) {
			$table->dropForeign('freight_categories_freight_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_order_id_foreign');
		});
		Schema::table('order_products', function(Blueprint $table) {
			$table->dropForeign('order_products_product_id_foreign');
		});
		Schema::table('variants', function(Blueprint $table) {
			$table->dropForeign('variants_product_id_foreign');
		});
		Schema::table('patrimonies', function(Blueprint $table) {
			$table->dropForeign('patrimonies_product_id_foreign');
		});
		Schema::table('variant_values', function(Blueprint $table) {
			$table->dropForeign('variant_values_variant_id_foreign');
		});
		Schema::table('order_status', function(Blueprint $table) {
			$table->dropForeign('order_status_order_id_foreign');
		});
		Schema::table('delivery_addresses', function(Blueprint $table) {
			$table->dropForeign('delivery_addresses_customer_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_bank_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_benefeciary_id_foreign');
		});
		Schema::table('beneficiary_addresses', function(Blueprint $table) {
			$table->dropForeign('beneficiary_addresses_beneficiary_id_foreign');
		});
		Schema::table('payment_slips', function(Blueprint $table) {
			$table->dropForeign('payment_slips_bank_account_id_foreign');
		});
		Schema::table('payment_slips', function(Blueprint $table) {
			$table->dropForeign('payment_slips_customer_id_foreign');
		});
		Schema::table('payment_slip', function(Blueprint $table) {
			$table->dropForeign('payment_slip_order_id_foreign');
		});
	}
}