<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Patrimony extends Eloquent {

	protected $table = 'patrimonies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'number', 'available', 'softDeletes');
	protected $visible = array('product_id', 'number', 'available', 'softDeletes');

	public function product()
	{
		return $this->belongsTo('Product');
	}

}