<?php

namespace Announcement;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Announcement extends Model 
{

    protected $table = 'announcements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brands()
    {
        return $this->hasMany('AnnouncementBrand');
    }

    public function brandches()
    {
        return $this->hasMany('AnnouncementBranch');
    }

    public function members()
    {
        return $this->hasMany('AnnouncementMember');
    }

}