<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('type')->unsigned()->default('0');
			$table->integer('status')->unsigned()->index()->default('0');
			$table->string('lang', 5)->nullable()->index();
			$table->string('nickname', 191)->nullable();
			$table->string('age')->nullable();
			$table->text('experience')->nullable();
			$table->string('axie_time')->nullable();
			$table->string('nick_telegram')->nullable();
			$table->string('email')->nullable();
			$table->text('from')->nullable();
			$table->text('utm')->nullable();
			$table->string('fio')->nullable();
			$table->tinyInteger('investor_type')->unsigned()->nullable();
			$table->string('company_name')->nullable();
			$table->string('site')->nullable();
			$table->tinyInteger('invest_time')->nullable()->default('0');
			$table->string('invest_summ')->nullable();
			$table->string('activity')->nullable();
			$table->string('partnership_type')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}