<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->index();
			$table->tinyInteger('age')->unsigned()->nullable();
			$table->text('experience');
			$table->text('skills')->nullable();
			$table->bigInteger('account_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}