<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Setting extends Model 
{

    protected $table = 'settings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Environment()
    {
        return $this->belongsTo('Environment');
    }

    public function Timers()
    {
        return $this->hasMany('TimerSetting');
    }

    public function Incubator()
    {
        return $this->hasOne('IncubatorSettings');
    }

    public function VivariumSetting()
    {
        return $this->hasOne('VivariumSettings');
    }

}