<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHardwareTable extends Migration {

	public function up()
	{
		Schema::create('hardware', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('location_id')->unsigned();
			$table->integer('real_quantity')->default('0');
			$table->integer('surrogate_quantity')->default('0');
			$table->integer('section')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('hardware');
	}
}