<?php

namespace Stream;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stream extends Model 
{

    protected $table = 'Stream';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function videos()
    {
        return $this->hasMany('Media\Video', 'id');
    }

    public function images()
    {
        return $this->hasMany('Media\Image', 'id');
    }

    public function audios()
    {
        return $this->hasMany('Media\Audio', 'id');
    }

    public function body()
    {
        return $this->hasOne('Stream\Blob', 'id');
    }

    public function tags()
    {
        return $this->hasMany('Term\Tag', 'id');
    }

}