<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('folders', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('folders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('passwords', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->foreign('access_type_id')->references('id')->on('access_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('folders', function(Blueprint $table) {
			$table->dropForeign('folders_parent_id_foreign');
		});
		Schema::table('passwords', function(Blueprint $table) {
			$table->dropForeign('passwords_folder_id_foreign');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->dropForeign('folder_access_user_id_foreign');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->dropForeign('folder_access_folder_id_foreign');
		});
		Schema::table('folder_access', function(Blueprint $table) {
			$table->dropForeign('folder_access_access_type_id_foreign');
		});
	}
}