<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FolderAccess extends Model 
{

    protected $table = 'folder_access';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('Users');
    }

    public function folder()
    {
        return $this->hasOne('Folder');
    }

    public function accessType()
    {
        return $this->hasOne('AccessTypes');
    }

}