<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FolderAccess extends Eloquent {

	protected $table = 'folder_access';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('Users');
	}

	public function folder()
	{
		return $this->hasOne('Folder');
	}

	public function accessType()
	{
		return $this->hasOne('AccessTypes');
	}

}