<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeJobInformationsTable extends Migration {

	public function up()
	{
		Schema::create('employee_job_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('job_id')->unsigned();
			$table->string('employee_number');
			$table->string('contract_type');
			$table->date('receiving_work_date');
			$table->integer('contract_period')->unsigned();
			$table->double('salary');
			$table->double('salary_percentage')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employee_job_informations');
	}
}