<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('customer_name', 150);
			$table->string('phone', 10);
			$table->string('identification_number', 10);
			$table->integer('customer_service_id')->unsigned();
			$table->string('type', 50);
			$table->string('content', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}