<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallsTable extends Migration {

	public function up()
	{
		Schema::create('calls', function(Blueprint $table) {
			$table->increments('id');
			$table->string('customer_name');
			$table->string('phone', 10);
			$table->time('call_duration');
			$table->string('identification_number', 10);
			$table->integer('customer_service_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('calls');
	}
}