<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('product_id');
			$table->string('shape', 20);
			$table->float('weight', 10,4)->default('0');
			$table->string('color', 10);
			$table->string('clarity', 10);
			$table->string('measurements', 30);
			$table->string('cut_grade', 10);
			$table->string('lab', 10);
			$table->float('depth_percentage', 6,3)->default('0');
			$table->float('table_percentage', 6,3)->default('0');
			$table->string('gridle_thin', 10);
			$table->string('gridle_thick', 10);
			$table->float('gridle_percentage', 6,3);
			$table->string('culet_size', 10);
			$table->string('culet_condition', 20);
			$table->string('polish', 10);
			$table->string('symmetry', 10);
			$table->string('fluorescence_intensity', 10);
			$table->string('fluorescence_color', 10);
			$table->float('crown_height', 10,3);
			$table->float('crown_angle', 10,3);
			$table->float('pavilion_depth', 10,3);
			$table->float('pavilion_angle', 10,3);
			$table->float('product_price', 10,4)->default('0');
			$table->text('comment');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}