<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password', 'phone', 'blood_type', 'token');

    public function governorates()
    {
        return $this->belongsToMany('App\Governorate');
    }

    public function blood_types()
    {
        return $this->belongsToMany('App\BloodType');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Post');
    }

    public function donation_requests()
    {
        return $this->hasMany('App\DonationRequest');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Notification');
    }

}