<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Producto extends Model 
{

    protected $table = 'productos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nombre', 'stock', 'precio');

    public function categoria()
    {
        return $this->belongsTo('Categoria', 'categoria_id');
    }

    public function compras()
    {
        return $this->belongsToMany('Compra', 'producto_compra');
    }

}