<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('childs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('couples', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('disabilities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('childs', function(Blueprint $table) {
			$table->dropForeign('childs_user_id_foreign');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->dropForeign('parents_user_id_foreign');
		});
		Schema::table('couples', function(Blueprint $table) {
			$table->dropForeign('couples_user_id_foreign');
		});
		Schema::table('disabilities', function(Blueprint $table) {
			$table->dropForeign('disabilities_user_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
	}
}