<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChildsTable extends Migration {

	public function up()
	{
		Schema::create('childs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('pre_name');
			$table->string('first_name');
			$table->date('birth_date');
			$table->string('last_name');
			$table->enum('type', array('a', 'b'));
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('childs');
	}
}