<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Doctor extends Eloquent {

	protected $table = 'doctors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function branch()
	{
		return $this->hasMany('DoctorBranch');
	}

	public function room()
	{
		return $this->hasMany('RoomService');
	}

}