<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Purchase extends Eloquent {

	protected $table = 'purchases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function supplier()
	{
		return $this->belongsTo('Supplier', 'supplier_id');
	}

	public function purchaseProduct()
	{
		return $this->hasMany('PurchaseProduct');
	}

}