<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function service()
	{
		return $this->hasMany('ReservationService');
	}

	public function medication()
	{
		return $this->hasMany('Medication');
	}

	public function product()
	{
		return $this->hasMany('ReservationProduct');
	}

	public function invoice()
	{
		return $this->hasOne('Invoice');
	}

	public function treatmentPlan()
	{
		return $this->hasMany('TreatmentPlan');
	}

}