<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('opening_hours', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('opening_hours')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('price_lists', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('push_notifications', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_address_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_city_id_foreign');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->dropForeign('service_providers_address_id_foreign');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->dropForeign('service_providers_notification_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_service_provider_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_employee_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_address_id_foreign');
		});
		Schema::table('opening_hours', function(Blueprint $table) {
			$table->dropForeign('opening_hours_service_provider_id_foreign');
		});
		Schema::table('price_lists', function(Blueprint $table) {
			$table->dropForeign('price_lists_service_provider_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_service_provider_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_service_provider_id_foreign');
		});
		Schema::table('push_notifications', function(Blueprint $table) {
			$table->dropForeign('push_notifications_service_provider_id_foreign');
		});
	}
}