<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('idCreator')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('idRecruiter')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('idCompany')->references('id')->on('companys')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('vacancies_published', function(Blueprint $table) {
			$table->foreign('idVacancy')->references('id')->on('vacancies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('company_users', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('company_users', function(Blueprint $table) {
			$table->foreign('idCompany')->references('id')->on('companys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->foreign('idApplicant')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('idRole')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('idRole')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('idPermission')->references('id')->on('permissions')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('hybridauth_users', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->foreign('idCompany')->references('id')->on('companys')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->foreign('idVacancy')->references('id')->on('vacancies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('professional_experience', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('academic_studies', function(Blueprint $table) {
			$table->foreign('idPersona')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('academic_studies', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('person_languages', function(Blueprint $table) {
			$table->foreign('idPerson')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('recruiters', function(Blueprint $table) {
			$table->foreign('idAdmin')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recruiters', function(Blueprint $table) {
			$table->foreign('idRecruiter')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credit_bag_users', function(Blueprint $table) {
			$table->foreign('idBag')->references('id')->on('credit_bags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credit_bag_users', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->foreign('idExecutor')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->foreign('idAffected')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->foreign('idDetail')->references('id')->on('credit_bags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_idPerson_foreign');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_idCreator_foreign');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_idRecruiter_foreign');
		});
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_idCompany_foreign');
		});
		Schema::table('vacancies_published', function(Blueprint $table) {
			$table->dropForeign('vacancies_published_idVacancy_foreign');
		});
		Schema::table('company_users', function(Blueprint $table) {
			$table->dropForeign('company_users_idPerson_foreign');
		});
		Schema::table('company_users', function(Blueprint $table) {
			$table->dropForeign('company_users_idCompany_foreign');
		});
		Schema::table('applicants', function(Blueprint $table) {
			$table->dropForeign('applicants_idApplicant_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_idUser_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_idRole_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_idRole_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_idPermission_foreign');
		});
		Schema::table('hybridauth_users', function(Blueprint $table) {
			$table->dropForeign('hybridauth_users_idUser_foreign');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->dropForeign('scopes_idUser_foreign');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->dropForeign('scopes_idCompany_foreign');
		});
		Schema::table('scopes', function(Blueprint $table) {
			$table->dropForeign('scopes_idVacancy_foreign');
		});
		Schema::table('professional_experience', function(Blueprint $table) {
			$table->dropForeign('professional_experience_idPerson_foreign');
		});
		Schema::table('academic_studies', function(Blueprint $table) {
			$table->dropForeign('academic_studies_idPersona_foreign');
		});
		Schema::table('academic_studies', function(Blueprint $table) {
			$table->dropForeign('academic_studies_idPerson_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_idPerson_foreign');
		});
		Schema::table('person_languages', function(Blueprint $table) {
			$table->dropForeign('person_languages_idPerson_foreign');
		});
		Schema::table('recruiters', function(Blueprint $table) {
			$table->dropForeign('recruiters_idAdmin_foreign');
		});
		Schema::table('recruiters', function(Blueprint $table) {
			$table->dropForeign('recruiters_idRecruiter_foreign');
		});
		Schema::table('credit_bag_users', function(Blueprint $table) {
			$table->dropForeign('credit_bag_users_idBag_foreign');
		});
		Schema::table('credit_bag_users', function(Blueprint $table) {
			$table->dropForeign('credit_bag_users_idUser_foreign');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->dropForeign('transaction_history_idExecutor_foreign');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->dropForeign('transaction_history_idAffected_foreign');
		});
		Schema::table('transaction_history', function(Blueprint $table) {
			$table->dropForeign('transaction_history_idDetail_foreign');
		});
	}
}