<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Scenarios', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('Commands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Scenarios', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ScenarioParts', function(Blueprint $table) {
			$table->foreign('scenario_id')->references('id')->on('Scenarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ScenarioParts', function(Blueprint $table) {
			$table->foreign('command_part_id')->references('id')->on('CommandParts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CommandParts', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('Commands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CommandParts', function(Blueprint $table) {
			$table->foreign('command_type_id')->references('id')->on('CommandTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Scenarios', function(Blueprint $table) {
			$table->dropForeign('Scenarios_command_id_foreign');
		});
		Schema::table('Scenarios', function(Blueprint $table) {
			$table->dropForeign('Scenarios_user_id_foreign');
		});
		Schema::table('ScenarioParts', function(Blueprint $table) {
			$table->dropForeign('ScenarioParts_scenario_id_foreign');
		});
		Schema::table('ScenarioParts', function(Blueprint $table) {
			$table->dropForeign('ScenarioParts_command_part_id_foreign');
		});
		Schema::table('CommandParts', function(Blueprint $table) {
			$table->dropForeign('CommandParts_command_id_foreign');
		});
		Schema::table('CommandParts', function(Blueprint $table) {
			$table->dropForeign('CommandParts_command_type_id_foreign');
		});
	}
}