<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DomainSitemap extends Model 
{

    protected $table = 'domain_sitemap';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function scans()
    {
        return $this->hasMany('ScanScheduler');
    }

    public function urls()
    {
        return $this->hasMany('URL');
    }

}