<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUrlsTable extends Migration {

	public function up()
	{
		Schema::create('urls', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('domain_sitemap_id')->unsigned();
			$table->string('url', 256)->unique();
			$table->string('hash', 32)->unique();
			$table->date('last_scan');
			$table->timestamps();
			$table->softDeletes();
			$table->smallInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('urls');
	}
}