<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEscalationsTable extends Migration {

	public function up()
	{
		Schema::create('escalations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('UC', 'MC', 'AE'))->index();
			$table->integer('transcription_id')->unsigned()->index();
			$table->string('confirmation', 255);
			$table->boolean('client_informed')->default(0);
			$table->timestamp('client_informed_time')->nullable();
			$table->timestamp('confirmation_time');
		});
	}

	public function down()
	{
		Schema::drop('escalations');
	}
}