<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExtractsTable extends Migration {

	public function up()
	{
		Schema::create('extracts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned()->index();
			$table->timestamp('last_sent')->nullable();
			$table->text('filter')->nullable();
			$table->string('recipient', 255)->nullable();
			$table->string('format', 75)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('extracts');
	}
}